function [ZLP,ZLP_old,ArtifactsLog] = ArtifactsZLP(handles,ZLP,ZLP_old,Cut,Drift,EnergyRes)

Thres   = str2double(get(handles.Thres,'String'));
a       = 0;
Run     = 0;
Drift   = Cut + round(Drift./EnergyRes);
Norm    = sum(ZLP,3);
ZLP     = ZLP./Norm;
ZLP_old = ZLP_old./Norm;
Count = 1;
while Count~=0
    Run=Run+1;
    if Run==1
        Answer = questdlg('Remove Artifacts from ZLP?','ZLP Artifact removal','Yes','No','No');
        if ~(size(Answer,2)==3)
            ZLP          = ZLP.*    Norm;
            ZLP_old      = ZLP_old.*Norm;
            ArtifactsLog = {[]};
            clearvars -except ZLP ZLP_old ArtifactsLog
            return
        end
    else
        switch Count
            case 1
                Answer = questdlg([num2str(Count),' Artifact removed! Remove further Artifacts from ZLP?'],'ZLP Artifact removal','Yes','No','No');
            otherwise
                Answer = questdlg([num2str(Count),' Artifacts removed! Remove further Artifacts from ZLP?'],'ZLP Artifact removal','Yes','No','No');
        end
    end
    switch Answer
        case 'Yes'
            tic;
            SizeX   = size(ZLP,2);
            SizeY   = size(ZLP,1);
            SizeZ   = size(ZLP,3);
            
            WaitTics = SizeZ;
            WaitArt  = parfor_wait(WaitTics, 'Waitbar', true,'ReportInterval',1);
            Count        = 0;
            for i=1:SizeZ
                img=reshape(ZLP(:,:,i),[SizeY,SizeX]);
                if SizeX>1 && SizeY>1
                    %% for the edges
                    pixel      = img(1,1);
                    Block      = img(1:2,1:2);
                    Block(1,1) = 0;
                    Block(1,1) = sum(Block,'all')/3;
                    Mean       = Block(1,1);
                    Std        = sqrt((std(Block,[],'all'))^2 *3/2);
                    if abs(pixel-Mean)>Thres*Std
                        Count                       = Count+1;
                        img(1,1)                    = Mean;
                        ZLP_old(1,1,i + Drift(1,1)) = Mean;
                    end
                    pixel      = img(1,SizeX);
                    Block      = img(1:2,SizeX-1:SizeX);
                    Block(1,2) = 0;
                    Block(1,2) = sum(Block,'all')/3;
                    Mean       = Block(1,2);
                    Std        = sqrt((std(Block,[],'all'))^2 *3/2);
                    if abs(pixel-Mean)>Thres*Std
                        Count                               = Count+1;
                        img(1,SizeX)                        = Mean;
                        ZLP_old(1,SizeX,i + Drift(1,SizeX)) = Mean;
                    end
                    pixel      = img(SizeY,1);
                    Block      = img(SizeY-1:SizeY,1:2);
                    Block(2,1) = 0;
                    Block(2,1) = sum(Block,'all')/3;
                    Mean       = Block(1,2);
                    Std        = sqrt((std(Block,[],'all'))^2 *3/2);
                    if abs(pixel-Mean)>Thres*Std
                        Count                               = Count+1;
                        img(SizeY,1)                        = Mean;
                        ZLP_old(SizeY,1,i + Drift(SizeY,1)) = Mean;
                    end
                    pixel      = img(SizeY,SizeX);
                    Block      = img(SizeY-1:SizeY,SizeX-1:SizeX);
                    Block(2,2) = 0;
                    Block(2,2) = sum(Block,'all')/3;
                    Mean       = Block(2,2);
                    Std        = sqrt((std(Block,[],'all'))^2 *3/2);
                    if abs(pixel-Mean)>Thres*Std
                        Count                                       = Count+1;
                        img(SizeY,SizeX)                            = Mean;
                        ZLP_old(SizeY,SizeX,i + Drift(SizeY,SizeX)) = Mean;
                    end
                    %% for the first rows
                    k=1;
                    for j = 2:SizeY-1
                        pixel      = img(j,k);
                        Block      = img((j-1):(j+1),k:(k+1));
                        Block(2,1) = 0;
                        Block(2,1) = sum(Block,'all')/5;
                        Mean       = Block(2,1);
                        Std        = sqrt((std(Block,[],'all'))^2 *5/4);
                        if abs(pixel-Mean)>Thres*Std
                            Count                       = Count+1;
                            img(j,k)                    = Mean;
                            ZLP_old(j,k,i + Drift(j,k)) = Mean;
                        end
                    end
                    
                    k=SizeX;
                    for j = 2:SizeY-1
                        pixel      = img(j,k);
                        Block      = img((j-1):(j+1),(k-1):k);
                        Block(2,2) = 0;
                        Block(2,2) = sum(Block,'all')/5;
                        Mean       = Block(2,2);
                        Std        = sqrt((std(Block,[],'all'))^2 *5/4);
                        if abs(pixel-Mean)>Thres*Std
                            Count                       = Count+1;
                            img(j,k)                    = Mean;
                            ZLP_old(j,k,i + Drift(j,k)) = Mean;
                        end
                    end
                    
                    j=1;
                    for k = 2:SizeX-1
                        pixel      = img(j,k);
                        Block      = img(j:(j+1),(k-1):(k+1));
                        Block(1,2) = 0;
                        Block(1,2) = sum(Block,'all')/5;
                        Mean       = Block(1,2);
                        Std        = sqrt((std(Block,[],'all'))^2 *5/4);
                        if abs(pixel-Mean)>Thres*Std
                            Count                       = Count+1;
                            img(j,k)                    = Mean;
                            ZLP_old(j,k,i + Drift(j,k)) = Mean;
                        end
                    end
                    
                    j=SizeY;
                    for k = 2:SizeX-1
                        pixel      = img(j,k);
                        Block      = img((j-1):j,(k-1):(k+1));
                        Block(2,2) = 0;
                        Block(2,2) = sum(Block,'all')/5;
                        Mean       = Block(2,2);
                        Std        = sqrt((std(Block,[],'all'))^2 *5/4);
                        if abs(pixel-Mean)>Thres*Std
                            Count                       = Count+1;
                            img(j,k)                    = Mean;
                            ZLP_old(j,k,i + Drift(j,k)) = Mean;
                        end
                    end
                end
                
                if SizeX>=5 && SizeY>=5
                    %% for the second rows
                    
                    for j = [2, SizeY-1]
                        for k=2:SizeX-1
                            pixel      = img(j,k);
                            Block      = img((j-1):(j+1),(k-1):(k+1));
                            Block(2,2) = 0;
                            Block(2,2) = sum(Block,'all')/8;
                            Mean       = Block(2,2);
                            Std        = sqrt((std(Block,[],'all'))^2 *8/7);
                            if abs(pixel-Mean)>Thres*Std
                                Count                       = Count+1;
                                img(j,k)                    = Mean;
                                ZLP_old(j,k,i + Drift(j,k)) = Mean;
                            end
                        end
                    end
                    
                    for j = 3:SizeY-2
                        for k = [2, SizeX-1]
                            pixel      = img(j,k);
                            Block      = img((j-1):(j+1),(k-1):(k+1));
                            Block(2,2) = 0;
                            Block(2,2) = sum(Block,'all')/8;
                            Mean       = Block(2,2);
                            Std        = sqrt((std(Block,[],'all'))^2 *8/7);
                            if abs(pixel-Mean)>Thres*Std
                                Count                       = Count+1;
                                img(j,k)                    = Mean;
                                ZLP_old(j,k,i + Drift(j,k)) = Mean;
                            end
                        end
                    end
                    
                    %% for the inner rows
                    for j = 3:SizeY-2
                        for k = 3:SizeX-2
                            pixel      = img(j,k);
                            Block      = img((j-2):(j+2),(k-2):(k+2));
                            Block(3,3) = 0;
                            Block(3,3) = sum(Block,'all')/24;
                            Mean       = Block(3,3);
                            Std        = sqrt((std(Block,[],'all'))^2 *24/23);
                            if abs(pixel-Mean)>Thres*Std
                                Count                       = Count+1;
                                img(j,k)                    = Mean;
                                ZLP_old(j,k,i + Drift(j,k)) = Mean;
                            end
                        end
                    end
                elseif SizeX>=3 && SizeY>=3
                    %% for the inner rows
                    for j = 2:SizeY-1
                        for k = 2:SizeX-1
                            pixel      = img(j,k);
                            Block      = img((j-1):(j+1),(k-1):(k+1));
                            Block(2,2) = 0;
                            Block(2,2) = sum(Block,'all')/8;
                            Mean       = Block(3,3);
                            Std        = sqrt((std(Block,[],'all'))^2 *8/7);
                            if abs(pixel-Mean)>Thres*Std
                                Count                       = Count+1;
                                img(j,k)                    = Mean;
                                ZLP_old(j,k,i + Drift(j,k)) = Mean;
                            end
                        end
                    end
                end
                ZLP(:,:,i)=img;
                
                %% Check Waitbar exist
                Flag = CheckWaitbar1(WaitArt);
                if Flag==1 
                    a            = a + Count;
                    ZLP          = ZLP.*    Norm;
                    ZLP_old      = ZLP_old.*Norm;
                    ArtifactsLog = {['RemArtifacts:  Thres: ',num2str(Thres),'  |  Removed Artifacts: ',num2str(a),' | Removal terminated!'];};
                    clearvars -except ZLP ZLP_old ArtifactsLog
                    return
                end
                WaitArt.Send;
                
            end
            a   = a + Count;
            WaitArt.Destroy;
            toc;
        otherwise
            ZLP     = ZLP.*    Norm;
            ZLP_old = ZLP_old.*Norm;
            ArtifactsLog={['RemArtifacts:  Thres: ',num2str(Thres),'  |  Removed Artifacts: ',num2str(a)];};
            clearvars -except ZLP ZLP_old ArtifactsLog
            return
    end  
end
ZLP     = ZLP.*Norm;
ZLP_old = ZLP_old.*Norm;
ArtifactsLog={['RemArtifacts:  Thres: ',num2str(Thres),'  |  Removed Artifacts: ',num2str(a),' | Removal finished!'];};
clearvars -except ZLP ZLP_old ArtifactsLog
end
